<?php
/* --------------------------------------------------------------
   WithdrawalService.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Interfaces;

use Gambio\Admin\Withdrawal\Exceptions\WithdrawalNotFoundException;

/**
 * Interface WithdrawalService
 *
 * @package Gambio\Admin\Withdrawal\Interfaces
 */
interface WithdrawalService
{
    /**
     * @param WithdrawalSqlCriteria   $criteria
     * @param WithdrawalSqlPagination $pagination
     *
     * @return Withdrawals
     */
    public function getAllWithdrawals(
        WithdrawalSqlCriteria $criteria,
        WithdrawalSqlPagination $pagination
    ): Withdrawals;
    
    
    /**
     * @param WithdrawalSqlCriteria $criteria
     *
     * @return int
     */
    public function getTotalCountOfWithdrawals(WithdrawalSqlCriteria $criteria): int;
    
    
    /**
     * @param WithdrawalId $id
     *
     * @return Withdrawal
     *
     * @throws WithdrawalNotFoundException
     */
    public function getWithdrawalById(WithdrawalId $id): Withdrawal;
    
    
    /**
     * @param Withdrawal $Withdrawal
     *
     * @return WithdrawalId
     */
    public function storeWithdrawal(Withdrawal $Withdrawal): WithdrawalId;
    
    
    /**
     * @param Withdrawals $Withdrawals
     *
     * @return WithdrawalIds
     */
    public function storeWithdrawals(Withdrawals $Withdrawals): WithdrawalIds;
    
    
    /**
     * @param WithdrawalId $id
     */
    public function deleteWithdrawal(WithdrawalId $id): void;
    
    
    /**
     * @param WithdrawalIds $ids
     */
    public function deleteWithdrawals(WithdrawalIds $ids): void;
}